/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.domsec;

import com.ibm.hwmca.base.domsec.DomainSecurityBean;
import com.ibm.hwmca.base.domsec.DomainSecurityIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domsec.DomainSecurity;
import com.ibm.hwmca.fw.domsec.DomainSecurityException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DomainSecurityTasklet
extends PanelTasklet
implements DomainSecurityIds {
    private static final String TRACE_MASKT = "HACADSTT";
    private static final String TRACE_MASKF = "HACADSTF";
    private static final String TRACE_MASKD = "HACADSTD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.domsec.res.DomainSecurityRes";
    private static final String PANEL_NAME = "DomainSecurityPanel";
    private List implList = null;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$domsec$DomainSecurity;

    public DomainSecurityTasklet() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityTasklet.DomainSecurityTasklet()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityTasklet.logException(" + throwable + ")");
        new FrameworkLog(DomainSecurityIds.logInfo, 2, throwable).log();
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.logException()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityTasklet.service()");
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): request.isInitialRequest(), displaying the panel.");
            try {
                DomainSecurityBean bean = new DomainSecurityBean();
                bean.setBeanName("DomainSecurityBean");
                byte[] b = SimServer.getSimServer().readSim(18);
                String name = new String(b);
                if (b[0] == 0) {
                    bean.setCurrentDomainNameOutput("NOT SET");
                } else {
                    int i = name.indexOf(0);
                    bean.setCurrentDomainNameOutput(name.substring(0, i));
                }
                boolean isChangeMgt = HMC.getHMC().getLiccEnabled();
                if (isChangeMgt) {
                    response.replace(AUIML_FILE_NAME, PANEL_NAME, bean);
                }
                this.showMessageBox(true, new BaseMessageTitle("HACA800D"), new BaseMessageText("HACA000D"), null, null);
                response.terminate();
            }
            catch (Exception exc) {
                throw new TaskletException(exc);
            }
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): request.isDisposed() or isCanceled, issue response.terminate.");
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.service(): request.getData(): " + request.getData("event") + ".");
            String event = (String)request.getData("event");
            DomainSecurityBean bean = (DomainSecurityBean)request.getData("data");
            if (event.equals("CANCEL")) {
                Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): Cancel request, end panel.");
                response.terminate();
            } else if (event.equals("ApplyHMCItem")) {
                this.verifyData(bean);
                if (this.setHmc(bean.getDomainNameEdit().getBytes(), bean.getNewPasswordEdit().getBytes())) {
                    FrameworkEventText fet = new FrameworkEventText(787);
                    new SystemEventLog(fet, "DOMPWCHG").log();
                    new E4EventLog(fet, "DOMPWCHG").log();
                    this.showMessageBox(true, new BaseMessageTitle("HACA800K"), new BaseMessageText("HACA000K"), null, null);
                    response.update(null);
                } else {
                    this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA0008"), null, null);
                    response.noAction();
                }
            } else if (event.equals("ResetMfgDefaultItem")) {
                byte[] abDomain;
                try {
                    byte[] bHmcType = SimServer.getSimServer().readSim(5);
                    switch (bHmcType[0]) {
                        case 1: 
                        case 3: {
                            abDomain = DomainSecurityIds.HACA_SE_DOMAIN;
                            break;
                        }
                        default: {
                            abDomain = DomainSecurityIds.HACA_HMC_DOMAIN;
                            break;
                        }
                    }
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): Exception reading XCPC_STATUS SIM field");
                    Trace.trace(TRACE_MASKF, hexc);
                    abDomain = DomainSecurityIds.HACA_HMC_DOMAIN;
                }
                if (this.setHmc(abDomain, DomainSecurityIds.HACA_LU_PASSWORD)) {
                    FrameworkEventText fet = new FrameworkEventText(787);
                    new SystemEventLog(fet, "DOMPWCHG").log();
                    new E4EventLog(fet, "DOMPWCHG").log();
                    this.showMessageBox(true, new BaseMessageTitle("HACA800K"), new BaseMessageText("HACA000K"), null, null);
                    response.update(null);
                } else {
                    this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA0008"), null, null);
                    response.noAction();
                }
            } else {
                this.verifyData(bean);
                if (event.equals("ApplyDefinedObjectsItem")) {
                    byte[] pw;
                    byte[] name = bean.getDomainNameEdit().getBytes();
                    String errorMessage = this.setAll(name, pw = bean.getNewPasswordEdit().getBytes());
                    if (errorMessage == null) {
                        if (this.setHmc(name, pw)) {
                            FrameworkEventText fet = new FrameworkEventText(787);
                            new SystemEventLog(fet, "DOMPWCHG").log();
                            new E4EventLog(fet, "DOMPWCHG").log();
                            this.showMessageBox(true, new BaseMessageTitle("HACA800K"), new BaseMessageText("HACA000K"), null, null);
                            response.update(null);
                        } else {
                            this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA0008"), null, null);
                            response.noAction();
                        }
                    } else {
                        this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA000B", new String[]{errorMessage}), null, null);
                        response.noAction();
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): Unknown request sent to the DomainSecurityTasklet.");
                    response.terminate();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.service()");
    }

    private String setAll(byte[] name, byte[] pw) {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityTasklet.setAll()");
        String s = null;
        this.implList = this.findUsers();
        Iterator iterator = this.implList.iterator();
        while (iterator.hasNext()) {
            DomainSecurity implClass = (DomainSecurity)iterator.next();
            try {
                implClass.getReady(name, pw);
                implClass.alter();
            }
            catch (DomainSecurityException exc) {
                Trace.trace(TRACE_MASKF, exc);
                implClass.abort();
                s = exc.getMessage().substring(0, exc.getMessage().indexOf(" ") + 1);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.setAll().");
        return s;
    }

    private boolean setHmc(byte[] name, byte[] pw) {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityTasklet.setHmc()");
        boolean result = true;
        try {
            SimServer.getSimServer().writeSim(18, name);
            SimServer.getSimServer().writeSim(17, pw);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            result = false;
        }
        if (this.implList == null) {
            this.implList = this.findUsers();
        }
        Iterator iterator = this.implList.iterator();
        while (iterator.hasNext()) {
            DomainSecurity implClass = (DomainSecurity)iterator.next();
            implClass.nameHasChanged();
        }
        if (result) {
            int i = 0;
            while (i < name.length) {
                if (name[i] == 0) break;
                ++i;
            }
            String group = new String(name, 0, i);
            FcsServer fcsServer = FcsServer.getFcsServer();
            if (fcsServer != null) {
                fcsServer.domainNameChanged(group);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.setHmc(): returns " + result);
        return result;
    }

    private void verifyData(DomainSecurityBean bean) {
        String s;
        byte[] b;
        Trace.trace(TRACE_MASKT, "-> DomainSecurityTasklet.verifyData()");
        if (bean.getDomainNameEdit() == null || bean.getDomainNameEdit().length() == 0) {
            try {
                b = SimServer.getSimServer().readSim(18);
                s = new String(b);
                bean.setDomainNameEdit(s);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        if (bean.getNewPasswordEdit() == null || bean.getNewPasswordEdit().length() == 0) {
            try {
                b = SimServer.getSimServer().readSim(17);
                s = new String(b);
                bean.setNewPasswordEdit(s);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.verifyData()");
    }

    private List findUsers() {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityTasklet.findUsers()");
        Object impl = null;
        ClassId[] ids = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = DomainSecurityTasklet.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower), new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = DomainSecurityTasklet.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject)};
        this.implList = new ArrayList();
        Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(ids);
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            HwmcaObject obj = (HwmcaObject)iterator.next();
            if (obj instanceof Tower) {
                Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.findUsers(): Tower found = " + ((Tower)obj).getName() + ".");
                impl = ((Tower)obj).getInterfaceImpl(class$com$ibm$hwmca$fw$domsec$DomainSecurity == null ? DomainSecurityTasklet.class$("com.ibm.hwmca.fw.domsec.DomainSecurity") : class$com$ibm$hwmca$fw$domsec$DomainSecurity);
            } else if (obj instanceof ManagedObject) {
                Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.findUsers(): ManagedObject found = " + ((ManagedObject)obj).getName() + ".");
                impl = ((ManagedObject)obj).getInterfaceImpl(class$com$ibm$hwmca$fw$domsec$DomainSecurity == null ? DomainSecurityTasklet.class$("com.ibm.hwmca.fw.domsec.DomainSecurity") : class$com$ibm$hwmca$fw$domsec$DomainSecurity);
            }
            if (impl == null) continue;
            Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.findUsers(): Add to list.");
            this.implList.add(impl);
            impl = null;
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.findUsers().");
        return this.implList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

